<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Jobseekers
{
	private $table_name = "jobseekers";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [
            "first_name" => strip_tags($data['first_name']),
            "last_name" => strip_tags($data['last_name']),
            "phone" => strip_tags($data['phone']),
            "address" => strip_tags($data['address']), 
            "gender" => strip_tags($data['gender']),           
            "age" => strip_tags($data['age']), 
            "skills" => strip_tags($data['skills']), 
            "edu_level" => strip_tags($data['edu_level']),
            "description" => strip_tags($data['description']), 
            "accepted_status" => strip_tags($data['accepted_status']),
            "email" => strip_tags($data['email']),           
            "password" => md5(strip_tags($data['password'])),
            "propic" => strip_tags($data['propic']),
            "cvdoc" => strip_tags($data['cvdoc']),
            "created_at" => strip_tags($data['created_at']),
            "created_by" => strip_tags($data['created_by'])

        ]);

         $last_id = $this->connection->id();

        return $last_id;
	}

	function update($data){

    if(strip_tags($data['password']) != ''){

      $status = $this->connection->update($this->table_name, [
            "first_name" => strip_tags($data['first_name']),
            "last_name" => strip_tags($data['last_name']),
            "phone" => strip_tags($data['phone']),
            "address" => strip_tags($data['address']), 
            "gender" => strip_tags($data['gender']),           
            "age" => strip_tags($data['age']), 
            "skills" => strip_tags($data['skills']), 
            "edu_level" => strip_tags($data['edu_level']),
            "description" => strip_tags($data['description']), 
            "accepted_status" => strip_tags($data['accepted_status']),
            "email" => strip_tags($data['email']),           
            "password" => md5(strip_tags($data['password'])),
            "propic" => strip_tags($data['propic']),
            "cvdoc" => strip_tags($data['cvdoc']),                          
            "updated_at" => strip_tags($data['updated_at']),
            "updated_by" => strip_tags($data['updated_by']),
          ], ["id" => strip_tags($data['id'])]);


    }else{

      $status = $this->connection->update($this->table_name, [
           "first_name" => strip_tags($data['first_name']),
            "last_name" => strip_tags($data['last_name']),
            "phone" => strip_tags($data['phone']),
            "address" => strip_tags($data['address']), 
            "gender" => strip_tags($data['gender']),           
            "age" => strip_tags($data['age']), 
            "skills" => strip_tags($data['skills']), 
            "edu_level" => strip_tags($data['edu_level']),
            "description" => strip_tags($data['description']), 
            "accepted_status" => strip_tags($data['accepted_status']),
            "email" => strip_tags($data['email']),           
            "password" => md5(strip_tags($data['password'])),
            "propic" => strip_tags($data['propic']),
            "cvdoc" => strip_tags($data['cvdoc']),                          
            "updated_at" => strip_tags($data['updated_at']),
            "updated_by" => strip_tags($data['updated_by']),
          ], ["id" => strip_tags($data['id'])]);



    }

		
	    

        return $status;
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status
            
        ], ["id" => $id]);
        return $status;
	}


      function setAsStatus($data){
            $status = $this->connection->update($this->table_name, [            
            "accepted_status" => strip_tags($data['status']),
             "password" => md5(strip_tags($data['password']))
            
        ], ["id" => strip_tags($data['id'])]);
        return $status;
      }

      
      function changeRequestmailStatus($data){
            $status = $this->connection->update($this->table_name, [
            "requestmail_status" => strip_tags($data['requestmail_status'])
            
        ], ["id" => strip_tags($data['id'])]);
        return $status;
      }


	function delete($id){

            date_default_timezone_set('Asia/Colombo');
            $date = date("Y-m-d H:i:s");
            
            $status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
      }

	function selectAll(array $filters = null){
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
            $data = $this->connection->select($this->table_name, '*', "WHERE deleted_at IS NULL $filter_txt ORDER BY id DESC");
            return $data;
      }

      function selectAllSearch($search_txt,array $filters = null){

            $search_txt = Common::textToSQLLikeString($search_txt);
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
           
            $data = $this->connection->query("SELECT * FROM $this->table_name WHERE (first_name $search_txt OR subject $search_txt OR email $search_txt) AND deleted_at IS NULL $filter_txt ORDER BY id DESC")->fetchAll();
            return $data;
      }

	function selectAllbyId($id){

		$data = $this->connection->select($this->table_name, '*', "WHERE FIND_IN_SET($id,vendor_type)  AND deleted_at IS NULL ORDER BY id DESC");
		return $data;
	}

	function selectAllQuery(array $filters = null){
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
            return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL $filter_txt ORDER BY id DESC" ;
      }

      function selectAllQuerySearch($search_txt,array $filters = null){
            $search_txt = Common::textToSQLLikeString($search_txt);
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
            return "SELECT * FROM $this->table_name WHERE (first_name $search_txt OR subject $search_txt OR email $search_txt) AND deleted_at IS NULL $filter_txt ORDER BY id DESC";
      }

	function selectAllQuerybyVendor($id){
		return "SELECT * FROM $this->table_name WHERE FIND_IN_SET($id,vendor_type) AND deleted_at IS NULL ORDER BY id DESC" ;
	}

      function selectAllQueryforApproval(){
            return "SELECT * FROM $this->table_name WHERE accepted_status=0 AND deleted_at IS NULL ORDER BY id DESC" ;
      }

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
	}

  function getByUserId($id){

     if ($_SESSION['fbToken'] == 1) {

      $data = $this->connection->select($this->table_name, '*', " WHERE fb_id=$id AND deleted_at IS NULL");
      return $data;

     } if ($_SESSION['googleToken'] == 1) {

      $data = $this->connection->select($this->table_name, '*', " WHERE google_id=$id AND deleted_at IS NULL");
      return $data;

     }

  }


	function getusernamebyid($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
	}

      function selectAllforPublishers(){

            $data = $this->connection->select($this->table_name, '*', " WHERE FIND_IN_SET(0,vendor_type) AND accepted_status=1 AND deleted_at IS NULL");
            return $data;
      }

      function selectAllforRatecards(){

            $data = $this->connection->select($this->table_name, '*', " WHERE accepted_status=1 AND deleted_at IS NULL");
            return $data;
      }

      function selectAllforFront($id){

            $data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
            return $data;
      }

      function selectAlldata(){

            $data = $this->connection->select($this->table_name, '*', "WHERE deleted_at IS NULL ORDER BY id DESC");
            return $data;
      }

      function selectAllfordashboard(){

            $data = $this->connection->select($this->table_name, '*', "WHERE accepted_status=0 AND requestmail_status=1  AND deleted_at IS NULL");
            return $data;
      }

      static function getAcceptedStatusType(){
            return array("Pending","Approved","Declined");
      }

      static function getEduLevel(){
            return array("O/L", "A/L","Bachelor","Masters","Doctor");
      }

      static function getGender(){
            return array("Male", "Female");
      }

      static function getRate(){
            return array("1", "2", "3", "4", "5");
      }

      static function getClassType(){
            return array("IT", "Business", "HR" , "Accounts");
      }

      static function getServicesArray()
      {
            return array(
                  "Publisher Partner",
                  "Video Production",
                  "Digital Development",
                  "Freelancer"
            );
      }

      function selectAllCity(){
           $data = $this->connection->query("SELECT * FROM district")->fetchAll();
            return $data;
      }

      function loadcitybyid($id){

            $data = $this->connection->query("SELECT * FROM city WHERE did=$id")->fetchAll();
            return $data;
      }

      function loadsubjectbyid($id){

            $data = $this->connection->query("SELECT * FROM subjects WHERE category=$id")->fetchAll();
            return $data;
      }

      function loadcitybyforupdate($id){

            $data = $this->connection->query("SELECT * FROM city WHERE cid=$id")->fetchAll();
            return $data;
      }

      function loadsubjectbyforupdate($id){

            $data = $this->connection->query("SELECT * FROM subjects WHERE id=$id")->fetchAll();
            return $data;
      }

       function addLocations($tid,$did,$id,$sid){

            $data = $this->connection->query("INSERT INTO teaching_area (teacher_id,district_id,location_id,subject_id) VALUES ($tid,$did,$id,$sid)")->fetchAll();
            return $data;
      }

      function deleteLocations($id){

             $data = $this->connection->query("DELETE FROM teaching_area WHERE teacher_id=$id ")->fetchAll();
            return $status;
      }

      function deleteSubjects($id){

             $data = $this->connection->query("DELETE FROM teaching_subjects WHERE teacher_id=$id ")->fetchAll();
            return $status;
      }

       function selectAllSubjects(){
           $data = $this->connection->query("SELECT * FROM subjects")->fetchAll();
            return $data;
      }

      function addSubjects($tid,$sid,$rate,$des){

        echo $description;

            $data = $this->connection->query("INSERT INTO teaching_subjects (teacher_id,subject_id,rate,description) VALUES ($tid,$sid,$rate,'$des')")->fetchAll();
            return $data;
      }

      function selectAllCityupdate($id){

         $data = $this->connection->query("SELECT * FROM teaching_area WHERE teacher_id = $id ")->fetchAll();
            return $data;
      }

      function selectAreaFromteacherSubjects($tid,$sid){

         $data = $this->connection->query("SELECT * FROM teaching_area WHERE (teacher_id = $tid AND subject_id = $sid)")->fetchAll();
            return $data;
      }

       function selectAllSubjectsupdate($id){

         $data = $this->connection->query("SELECT * FROM teaching_subjects WHERE teacher_id = $id ")->fetchAll();
            return $data;
      }

      function selectAllSubjectsbyId($id){
           $data = $this->connection->query("SELECT * FROM subjects WHERE id = $id")->fetchAll();
            return $data;
      }


      function getByUsernameAndEmailTeacher($primary_email, $password){
    $data = $this->connection->select($this->table_name, '*', " WHERE email='$primary_email' AND password='".md5($password)."' AND deleted_at IS NULL");
    return $data;
  }

  function selectAllQuerySearchFront(){
            return "SELECT * FROM $this->table_name WHERE accepted_status = 1 AND deleted_at IS NULL ORDER BY rand()";
      }


  function selectAllSearchFront(){           
            $data = $this->connection->query("SELECT * FROM $this->table_name WHERE accepted_status = 1 AND deleted_at IS NULL ORDER BY rand()")->fetchAll();
            return $data;
      }



   function selectAllQuerySearchFrontSearchWord($search_txt){

             $search_txt = Common::textToSQLLikeString($search_txt);

            return "SELECT * FROM $this->table_name WHERE (first_name $search_txt OR last_name $search_txt) AND accepted_status = 1 AND deleted_at IS NULL ORDER BY rand()";
      }


  function selectAllSearchFrontSearchWord($search_txt){ 

             $search_txt = Common::textToSQLLikeString($search_txt);

            $data = $this->connection->query("SELECT * FROM $this->table_name WHERE (first_name $search_txt OR last_name $search_txt) AND accepted_status = 1 AND deleted_at IS NULL ORDER BY rand()")->fetchAll();
            return $data;
      }

  function selectAllQuerySearchFrontSearch($district,$city,$subject,$classtype){

    
         $where="";           

          if ($district!="") {
             $where .= " ta.district_id=$district AND ";
          } 

          if ($city!="") {
             $where .= " ta.location_id=$city AND ";
          }           

          if ($subject!="") {
              $where .= " ts.subject_id=$subject AND ";
          } 

          if ($classtype!="") {
             $where .= " FIND_IN_SET($classtype,class_type) AND ";
          }

           

     
       //  if ($district==NULL) {
       //  return "SELECT * FROM $this->table_name WHERE (first_name $search_txt OR last_name $search_txt) AND deleted_at IS NULL ORDER BY id DESC";
       // }

      // if ($city==NULL) {
      //      return "SELECT t.* FROM $this->table_name as t, teaching_area as ta WHERE ta.district_id=$district AND (t.first_name $search_txt OR  t.last_name $search_txt) AND ta.teacher_id=t.id AND t.deleted_at IS NULL ORDER BY id DESC";
      // }else{
         return "SELECT t.* FROM $this->table_name as t, teaching_area as ta, teaching_subjects as ts WHERE $where ta.teacher_id=t.id AND ts.teacher_id=t.id AND t.deleted_at IS NULL ORDER BY id DESC";

      // }


           
      }


  function selectAllSearchFrontSearch($district,$city,$subject,$classtype){  

      

         $where="";           

          if ($district!="") {
             $where .= " ta.district_id=$district AND ";
          } 

          if ($city!="") {
             $where .= " ta.location_id=$city AND ";
          } 

          if ($subject!="") {
              $where .= " ts.subject_id=$subject AND ";
          } 

          if ($classtype!="") {
             $where .= " FIND_IN_SET($classtype,class_type) AND ";
          }    
      

       // if ($district==NULL) {

       //    $data = $this->connection->query("SELECT * FROM $this->table_name WHERE (first_name $search_txt OR last_name $search_txt) AND deleted_at IS NULL ORDER BY id DESC")->fetchAll();
       //      return $data;

       // }

      // if ($city==NULL) {
      //  $data = $this->connection->query("SELECT t.* FROM $this->table_name as t, teaching_area as ta WHERE ta.district_id=$district AND (t.first_name $search_txt OR  t.last_name $search_txt) AND ta.teacher_id=t.id AND t.deleted_at IS NULL ORDER BY id DESC")->fetchAll();
      //       return $data;
      // }else{
        $data = $this->connection->query("SELECT t.* FROM $this->table_name as t, teaching_area as ta, teaching_subjects as ts WHERE $where ta.teacher_id=t.id AND ts.teacher_id=t.id AND t.deleted_at IS NULL ORDER BY id DESC")->fetchAll();
            return $data;
      // }

      


      }


          // ******************added by ayona****************************

      function updateSeekerDes($data){

        $status = $this->connection->update($this->table_name, [
            "skills" => strip_tags($data['final-skills']),
            "description" => strip_tags($data['final-about']),
            "edu_level"  => strip_tags($data['final-qualifications']),
            "updated_at" => strip_tags($data['updated_at']),
            "updated_by" => strip_tags($data['updated_by']),
          ], ["id" => strip_tags($data['id'])]);
        
        return $status;
        
      }


      function updateSeeker2($data){
        // print_r($data);die();

        $status = $this->connection->update($this->table_name, [
            "first_name" => strip_tags($data['first_name']),
            "last_name" => strip_tags($data['last_name']),
            "email"  => strip_tags($data['email']),
            "phone"  => strip_tags($data['phone']),
            "address"  => strip_tags($data['address']),
            "propic"  => strip_tags($data['propic']),
            "age"  => strip_tags($data['age']),
            "description"  => strip_tags($data['description']),
            "gender"  => strip_tags($data['gender']),
            "updated_at" => strip_tags($data['updated_at']),
            "updated_by" => strip_tags($data['updated_by']),
          ], ["id" => strip_tags($data['id'])]);
        
        return $status;
        
      }
      
      function updatePassword($data){
          $status = $this->connection->update($this->table_name, [
            "password" => md5(strip_tags($data['password'])),
          ], ["id" => strip_tags($data['id'])]);
        
          return $status;
      }
      
     
      function selectByEmail($email){

        $data = $this->connection->select($this->table_name, '*', " WHERE email = '$email' AND deleted_at IS NULL");
        return $data;
      }

      function tokenInsert($data){
    
        $status = $this->connection->update($this->table_name, [
                "token" => strip_tags($data['token'])
                
            ], ["id" => strip_tags($data['id'])]);
            return $status;

      }
      
      function resetPassword($data){
        $status = $this->connection->update($this->table_name, [
            "password"  => md5(strip_tags($data['password'])),
            "updated_at" => strip_tags($data['updated_at']),
            "updated_by" => strip_tags($data['updated_by']),
          ], ["id" => strip_tags($data['id'])]);
        
        return $status;
      }

      // ****************/.added by ayona****************************



      // ****************/.added by WC****************************

    function getByUsernameAndEmailSeeker($email, $password){
    $data = $this->connection->select($this->table_name, '*', " WHERE accepted_status=1 AND email='$email' AND password='".md5($password)."' AND deleted_at IS NULL");
    return $data;
  }

    // ****************/.added by WC****************************
	

}

?>