<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Jobcategory
{
	private $table_name = "jobcategory";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [
            "name" => strip_tags($data['name']),                     
            "created_at" => strip_tags($data['created_at'])
        ]);

        return $status;
	}

	function update($data){

			$status = $this->connection->update($this->table_name, [	        
	        "name" => strip_tags($data['name']),           	            
	        "updated_at" => strip_tags($data['updated_at'])
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status
            
        ], ["id" => $id]);
        return $status;
	}

		function delete($id){

            date_default_timezone_set('Asia/Colombo');
            $date = date("Y-m-d H:i:s");
            
            $status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
      }

	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', 'WHERE deleted_at IS NULL ORDER BY id DESC');
		return $data;
	}

	function selectAllbyId($id){

		$data = $this->connection->select($this->table_name, '*', "WHERE deleted_at IS NULL AND id=$id");
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL ORDER BY id DESC" ;
	}

	function selectAllQuerybyJobcategory($id){
		return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL AND type=$id " ;
	}

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND id=$id ");
		return $data;
	}
	function getusernamebyid($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND id=$id ");
		return $data;
	}

	static function getJobcategoryCategory(){
            return array("O/L", "A/L","Bachelor","Masters","Doctor");
      }

    // *********added by ayona*******************

    function selectAllForFront(){

		$data = $this->connection->select($this->table_name, '*', 'WHERE deleted_at IS NULL ORDER BY id DESC');
		return $data;
	}
	
    // *********/. added by ayona ***************


	

}

?>