<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class AppliedJobs
{
	private $table_name = "applied_jobs";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}


  function store($data){
    $status = $this->connection->insert($this->table_name, [              
            "job_id" => strip_tags($data['jobid']),
            "job_seeker_id" => strip_tags($data['job_seeker_id']),
            "created_at" => strip_tags($data['created_at'])
        ]);

        return $status;
  }


  function delete($id){

    date_default_timezone_set('Asia/Colombo');
    $date = date("Y-m-d H:i:s");
            
    $status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
    ], ["id" => $id]);
     return $status;
  }


  function selectAll(){

    $data = $this->connection->select($this->table_name, '*', 'WHERE deleted_at IS NULL ORDER BY id DESC');
    return $data;
  }

  function selectAllQuery(){
    return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL ORDER BY id DESC" ;
  }



  function getAppliedjobs($seeker_id){
    $data = $this->connection->select($this->table_name, '*', "WHERE deleted_at IS NULL AND job_seeker_id = $seeker_id ORDER BY id DESC");
    return $data;
  }

  function getById($id){

    $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND id=$id ");
    return $data;
  }

  function deletePostedJob($id){
    date_default_timezone_set('Asia/Colombo');
            $date = date("Y-m-d H:i:s");
            
            $status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
  }


}

?>