<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

// error_reporting(E_ALL);

class Sessions
{

	static function setAdminLoginDetails($admin_id,$admin_username,$admin_full_name,$admin_type,$admin_type_deligate){

		$permi = new Userpermissions();



		$data_permi = $permi->getPermissionsById($admin_type); /////herer check

		$data_permi_deligate = $permi->getPermissionsById($admin_type_deligate);
		

		$_SESSION["admin_id"] = $admin_id;
		$_SESSION["admin_username"] = $admin_username;
		$_SESSION["admin_full_name"] = $admin_full_name;

		$_SESSION["admin_type"] = $data_permi;
		$_SESSION["admin_type_deligate"] = $data_permi_deligate;

		$_SESSION["has_deligate"] = $admin_type_deligate;
		$_SESSION["is_admin_logged"] = true;
	}	


	static function setBcuserLoginDetails($admin_id,$first_name,$last_name,$email,$parent,$category,$birth){

		//print_r($birth);die();

		$date = strtotime(date("Y-m-d"));

		if ($category == 0) {
			

			 $days = $date-strtotime($birth);
		}

		if ($category == 2) {

			 $days = strtotime($birth)-$date;
			
		}

		// print_r(round($days / (60 * 60 * 24))); die();



		$_SESSION["bcuser_id"] = $admin_id;
		$_SESSION["bcuser_full_name"] = $first_name." ".$last_name;
		$_SESSION["email"] = $email;	
		$_SESSION["parent_type"] = $parent;		
		$_SESSION["category"] = $category;	
		$_SESSION["birth_date"] = round($days / (60 * 60 * 24));	
		$_SESSION["is_bcuser_logged"] = true;
		
	}


	

	static function setUserClients($client_ids){
		$_SESSION["user_clients"] = $client_ids;
	}

	static function setUserTeamAndDesignation($team, $designation){
		$_SESSION["user_team"] = $team;
		$_SESSION["user_designation"] = $designation;
	}

	static function isAdminLogged(){
		if(isset($_SESSION['is_admin_logged']) && $_SESSION['is_admin_logged']==true){
			return true;
		}else{
			return false;
		}
	}

	static function isBcuserLogged(){
		if(isset($_SESSION['is_bcuser_logged']) && $_SESSION['is_bcuser_logged']==true){
			return true;
		}else{
			return false;
		}
	}

	static function getAdminId(){
		return $_SESSION["admin_id"];
	}

	static function getAdminType(){
		return $_SESSION["admin_type"];
	}

	static function getAdminTypeDeligate(){
		return $_SESSION["admin_type_deligate"];
	}

	static function getAdminHasDeligate(){
		return $_SESSION["has_deligate"];
	}

	static function getAdminFullName(){
		return $_SESSION["admin_full_name"];
	}
	
	static function adminRedirectOnNotLoggedIn(){

		if(!Sessions::isAdminLogged()){
		  header("Location: ".SITE_URL."login.php");
		  exit();
		}

	}

	static function bcuserRedirectOnNotLoggedIn(){

		if(!Sessions::isBcuserLogged()){
		  header("Location: index.php");
		  exit();
		}

	}

	static function getUserClients(){
		return $_SESSION["user_clients"];
	}

	static function getUserTeam(){
		return $_SESSION['user_team'];
	}

	static function getUserDesignation(){
		return $_SESSION['user_designation'];
	}

	static function logoutAdmin(){
		unset($_SESSION["admin_id"]);
		unset($_SESSION["admin_username"]);
		unset($_SESSION["is_admin_logged"]);
		unset($_SESSION["admin_full_name"]);
		unset($_SESSION["admin_type"]);
		unset($_SESSION["admin_type_deligate"]);
		unset($_SESSION["has_deligate"]);
	}

	static function logoutBcuser(){
		unset($_SESSION["bcuser_id"]);
		unset($_SESSION["bcuser_full_name"]);
		unset($_SESSION["is_bcuser_logged"]);
	    unset($_SESSION["email"]);
		unset($_SESSION["parent_type"]);	
		unset($_SESSION["birth_date"]);
	    unset($_SESSION["category"]);	
		
	}



}