<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Common
{
	/*
	* @return an array of time periods that reminders need to send
	*/
	static function getPlatformsArray()
	{
		return array(
			"Facebook",
			"Instagram",
			"LinkedIn",
			"Twitter",
			"Mobile",
			"Google Search",
			"Google Display",
			"Google Display/Search Remarketing",
			"Facebook Remarketing",
			"YouTube",
			"Direct",
			"Other"
		);
	}
	static function getCampaignObjectivesArray()
	{
		return array(
			"Awareness (Impressions/Reach)",
			"Video Views",
			"Engagement (Interactions)",
			"Conversions",
			"Website Traffic",
			"Page Likes",
			"other"
		);
	}
	static function otherMediaPlatformsArray()
	{
		return array(
			"TV",
			"Press",
			"Radio",
			"OOH",
			"PR & Activations",
			"Supporting material provided"
		);
	}
	static function getGenderArray()
	{
		return array(
			"Male",
			"Female"
		);
	}
	static function getLanguageArray()
	{
		return array(
			"English",
			"Sinhala",
			"Tamil"
		);
	}

	

	static function getPermissions($module, $type)
	{
		$datas = Sessions::getAdminType();
		$datas_deligate = Sessions::getAdminTypeDeligate();
		$has_deligate = Sessions::getAdminHasDeligate();
		$permission = json_decode($datas[0]['typearray']);
		$permission_deligate = json_decode($datas_deligate[0]['typearray']);
		$haspermission_1 = "";
		$haspermission_2 = "";
		foreach($permission as $key => $value) { //permission check start
			// echo $key."<br />";         //module names
			$module_name = $key;
			foreach($value as $k => $v) {
				foreach($v as $key => $val) {
					// print_r($key."=>");           //add,delete
					// print_r($val[0]."<br />");      //0 , 1
					// check correct module
					if ($module_name == $module && $key == $type) {
						$haspermission_1 = $val[0];
						// return $val[0];
					}
				}
			}
		} //permission check end
		foreach($permission_deligate as $key => $value) { //deligate permission check start
			$module_name_deligate = $key;
			foreach($value as $k => $v) {
				foreach($v as $key => $val) {
					if ($module_name_deligate == $module && $key == $type) {
						$haspermission_2 = $val[0];
						// return $val[0];
					}
				}
			}
		}
		// deligate permission check end
		if ($haspermission_1 == 1 || $haspermission_2 == 1) {
			return 1;
		}
		else {
			return 0;
		}
	}

	static function textToSQLLikeString($data){
	
		$data_arr = explode(" ",$data); 
		
		$final_string = "";
		
		foreach($data_arr as $k=>$v){

			$final_string .= "%";
			
			if($v!=""){
				$final_string .= "$v";
			}
			
			if(($k+1)==count($data_arr)){
				$final_string .= "%";
			}
			
		}
		
		return "LIKE '".$final_string."'";

		/*$data_arr = explode(" ",$data);

		$emptied_vals = array();

		foreach($data_arr as $k=>$v){
			if($v!=""){
				array_push($emptied_vals,$v);
			}
		}

		$data = implode(" ", $emptied_vals);

		return "REGEXP '(".str_replace(" ","|",$data).")'";	*/
	}

	/**
	generate where cluase text for filter array. 
	sample data array
	$data = array([0]=>array('name'=>'','value'=>''),[1]=>array(),..);
	**/
	static function arrayToSQLWhereClause($data,$table_prefix=''){ 
		$where = '';
		$k = 0;
		if(count($data)>0){
			$where .= 'AND ';
			foreach ($data as $row) {
				if($row['value']!=""){
					if($row['type']=='SINGLE'){
						if($table_prefix !=''){
							$where .= $table_prefix.'.';
						}
						$where .= $row['name']."=".$row['value'];
					}else if($row['type']=='FIND_IN_SET'){
						if($table_prefix !=''){
							$column = $table_prefix.'.'.$row['name'];
						}else{
							$column = $row['name'];
						}
						$where .= 'FIND_IN_SET('.$row['value'].",".$row['name'].')';
					}
				}
				
				if(($k+1)!=count($data)){
					$where .= " AND ";
				}
				$k++;
			}
		}
		
		return $where;
	}

	

}