<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;



class Users
{
	private $table_name = "users";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [
            "first_name" => strip_tags($data['first_name']),
            "last_name" => strip_tags($data['last_name']),
            "primary_email" => strip_tags($data['primary_email']), 
            "secondary_email" => strip_tags($data['secondary_email']),                
            "type" => strip_tags($data['type']),           
            "profilepic" => strip_tags($data['profilepic']),
            "username" => strip_tags($data['username']),
            "password" => md5(strip_tags($data['password'])),
            "created_at" => strip_tags($data['created_at']),
            "created_by" => strip_tags($data['created_by'])
        ]);

        return $status;
	}

	function update($data){

		
		

		if(strip_tags($data['password']) != ''){
			$status = $this->connection->update($this->table_name, [
	            "first_name" => strip_tags($data['first_name']),
	            "last_name" => strip_tags($data['last_name']),
	            "primary_email" => strip_tags($data['primary_email']), 
            	"secondary_email" => strip_tags($data['secondary_email']),
	            "username" => strip_tags($data['username']),	             
                "type" => strip_tags($data['type']),
                "deligate_user" => strip_tags($data['deligate_to']),                
           	    "profilepic" => strip_tags($data['profilepic']),
	            "password" => md5(strip_tags($data['password'])),
	            "updated_at" => strip_tags($data['updated_at']),
	            "updated_by" => strip_tags($data['updated_by'])
	        ], ["id" => strip_tags($data['id'])]);
	    }else{
	    	$status = $this->connection->update($this->table_name, [
	            "first_name" => strip_tags($data['first_name']),
	            "last_name" => strip_tags($data['last_name']),
	            "primary_email" => strip_tags($data['primary_email']), 
            	"secondary_email" => strip_tags($data['secondary_email']),
	            "username" => strip_tags($data['username']),          
     			"type" => strip_tags($data['type']),
     		    "deligate_user" => strip_tags($data['deligate_to']),     			
           	    "profilepic" => strip_tags($data['profilepic']),
	            "updated_at" => strip_tags($data['updated_at']),
	            "updated_by" => strip_tags($data['updated_by'])
	        ], ["id" => strip_tags($data['id'])]);
	    }

        return $status;
	}

	function updateDeligate($data){

			$status = $this->connection->update($this->table_name, [	       
	        "deligate_type" => strip_tags($data['deligate_type'])
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status
            
        ], ["id" => $id]);
        return $status;
	}

	function delete($id){

		date_default_timezone_set('Asia/Colombo');
		$date = date("Y-m-d H:i:s");


		$status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
	}

	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', 'WHERE deleted_at IS NULL ORDER BY id DESC');
		return $data;
	}

	function selectAllSearch($search_txt){

		$search_txt = Common::textToSQLLikeString($search_txt);
		//echo $search_txt;
		$data = $this->connection->query("SELECT * FROM $this->table_name WHERE (first_name $search_txt OR last_name $search_txt OR username $search_txt OR primary_email $search_txt) AND deleted_at IS NULL ORDER BY id DESC")->fetchAll();
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL ORDER BY id DESC";
	}

	function selectAllQuerySearch($search_txt){
		$search_txt = Common::textToSQLLikeString($search_txt);
		return "SELECT * FROM $this->table_name WHERE (first_name $search_txt OR last_name $search_txt OR username $search_txt OR primary_email $search_txt) AND deleted_at IS NULL ORDER BY id DESC";
	}

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL ");
		return $data;
	}

	function usersByTeamPm(){

		$data = $this->connection->select($this->table_name, '*', " WHERE team=2 AND deleted_at IS NULL");
		return $data;

	}

	function usersByTeamSm(){

		$data = $this->connection->select($this->table_name, '*', " WHERE team=3 AND deleted_at IS NULL ");
		return $data;

	}

	function usersByTeamCreative(){

		$data = $this->connection->select($this->table_name, '*', " WHERE team=4 AND deleted_at IS NULL ");
		return $data;

	}


	function getuserbySMHead(){

		$data = $this->connection->select($this->table_name, '*', " WHERE team=3 AND designation=1 AND deleted_at IS NULL");
		return $data;

	}

	function getuserbyPMHead(){

		$data = $this->connection->select($this->table_name, '*', " WHERE team=2 AND designation=1 AND deleted_at IS NULL");
		return $data;

	}

	function getuserbyCreativeHead(){

		$data = $this->connection->select($this->table_name, '*', " WHERE team=4 AND designation=1 AND deleted_at IS NULL");
		return $data;

	}

	function getuserbyDevelopmentHead(){

		$data = $this->connection->select($this->table_name, '*', " WHERE team=6 AND designation=1 AND deleted_at IS NULL");
		return $data;

	}


	function getByUsernameAndEmail($primary_email, $password){
		$data = $this->connection->select($this->table_name, '*', " WHERE primary_email='$primary_email' AND password='".md5($password)."' AND deleted_at IS NULL");
		return $data;
	}


	

	 function getusername($id){

	 	$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
		
	 }

	 function getCreativeTeam(){
	 	$data = $this->connection->select($this->table_name, '*', " WHERE team=4 AND deleted_at IS NULL");
		return $data;
	 }

	function getDevelopmentTeam(){
	 	$data = $this->connection->select($this->table_name, '*', " WHERE team=6 AND deleted_at IS NULL");
		return $data;
	}
	
	function getDevHead(){
		$data = $this->connection->select($this->table_name, '*', " WHERE team=6 AND designation=1 AND deleted_at IS NULL");
		return $data;
	}

	function getSuperUser(){
		$data = $this->connection->select($this->table_name, '*', " WHERE id=1 AND deleted_at IS NULL");
		if($data[0]['deligate_user']){
			$data2 = $this->connection->select($this->table_name, '*', " WHERE id=".$data[0]['deligate_user']." AND deleted_at IS NULL");
			return $data2;
		}
		return $data;
	}

	// *************************added by ayona**********************

	function getByUsernameAndEmailforReset($primary_email){
		$data = $this->connection->select($this->table_name, '*', " WHERE primary_email='$primary_email' AND deleted_at IS NULL");
		return $data;
	}

	// ************************/. added by ayona *******************

}

?>