<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;



class Emailheaders
{
	private $table_name = "emailheaders";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [
            "name" => strip_tags($data['name']),
            "content" => $data['content'],
            "created_at" => strip_tags($data['created_at']),
            "created_by" => strip_tags($data['created_by'])
        ]);

        return $status;
	}

	function update($data){

		$status = $this->connection->update($this->table_name, [
	        "name" => strip_tags($data['name']),
            "content" => $data['content'],
	        "updated_at" => strip_tags($data['updated_at']),
	        "updated_by" => strip_tags($data['updated_by'])
	    ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status
            
        ], ["id" => $id]);
        return $status;
	}

	function delete($id){
		$date = date("Y-m-d H:i:s");

		$status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
	}

	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', 'WHERE deleted_at IS NULL ORDER BY id DESC');
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL ORDER BY id DESC";
	}

	function getById($id){ 

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
	}


	function getusername($id){

	 	$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
		
	}

	
}

?>