<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class ActivityLog
{
	private $table_name = "activity_log";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [
            "created_date" => strip_tags($data['created_date']),
            "user" => strip_tags($data['user']),
            "module" => strip_tags($data['module']), 
            "type" => strip_tags($data['type']),                
            "message" => strip_tags($data['message']),
            "ip" => strip_tags($data['ip'])
        ]);

        return $status;
	}

	function update($data){
		

		
	    $status = $this->connection->update($this->table_name, [
	        "created_date" => strip_tags($data['created_date']),
            "user" => strip_tags($data['user']),
            "module" => strip_tags($data['module']), 
            "type" => strip_tags($data['type']),                
            "message" => strip_tags($data['message']),
            "ip" => strip_tags($data['ip'])
	    ], ["id" => strip_tags($data['id'])]);
	  
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status
            
        ], ["id" => $id]);
        return $status;
	}

	function delete($id){

		$status = $this->connection->delete($this->table_name, " WHERE id=$id ");
		return $status;
	}

	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', ' ORDER BY id DESC');
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM $this->table_name ORDER BY id DESC";
	}

	function selectAllWithUser(){

		$data = $this->connection->query("SELECT al.*,us.first_name,us.last_name FROM activity_log as al, users as us WHERE al.user=us.id ORDER BY al.id DESC")->fetchAll();
		return $data;
	}

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id ");
		return $data;
	}

	function newLogRecord($module,$type,$message){
      
      $admin_id = Sessions::getAdminId();

      $data['created_date'] = date("Y-m-d H:i:s");
      $data['user'] = $admin_id;
      $data['module'] = $module;
      $data['type'] = $type;
      $data['message'] = $message;
      $data['ip'] = $_SERVER['REMOTE_ADDR'];

	  $this->store($data);

	}

	function emptyTable(){
		$status = $this->connection->query("TRUNCATE TABLE $this->table_name");
		return $status;
	}

}

?>