<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Emailtemplates
{
	private $table_name = "email_templates";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}	

	function store($data){
		$status = $this->connection->insert($this->table_name, [
			"name" => strip_tags($data['name']),
			"code" => strip_tags($data['code']),
            "body" => $data['body'],
            "header" => strip_tags($data['header']),
            "footer" => strip_tags($data['footer']),          
            "created_at" => strip_tags($data['created_at']),
            "created_by" => strip_tags($data['created_by'])
        ]);

        return $status;
	}

	function update($data){

		$status = $this->connection->update($this->table_name, [
           "name" => strip_tags($data['name']),
			"code" => strip_tags($data['code']),
            "body" => $data['body'],
            "header" => strip_tags($data['header']),
            "footer" => strip_tags($data['footer']),       
            "updated_at" => strip_tags($data['updated_at']),
            "updated_by" => strip_tags($data['updated_by'])		           
        ], ["id" => strip_tags($data['id'])]);
	    
        return $status;
	}

	function delete($id){

		date_default_timezone_set('Asia/Colombo');
		$date = date("Y-m-d H:i:s");

		$status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
	}

	
	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', 'WHERE deleted_at IS NULL ORDER BY id DESC');
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL ORDER BY id DESC";
	}

	
	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
	}

	function getByCode($code){

		$data = $this->connection->select($this->table_name, '*', " WHERE code='".$code."' AND deleted_at IS NULL");
		return $data;
	}
	

	function replaceValues($values, $text) {

        foreach ($values as $key => $val) {
            $text = str_replace("{" . $key . "}", $val, $text);
        }

        return $text;
    }

    function sendEmail($data){ print_r($data);


	    $values = $data['values'];

		//$myArray = json_decode($arr, true);

		$code = $data['code'];
		$title = $data['title'];
		$to = $data['to'];
		$cc = $data['cc'];
		$bcc = $data['bcc'];

		$email = new Emailtemplates();
		//$email_data = $email->getById($tempid);
		$email_data = $email->getByCode($code); //print_r($email_data);

		//get header footer data
		$emailheader = $email_data[0]['header'];
		$emailfooter = $email_data[0]['footer'];	

		$email_header = new Emailheaders();
		$email_header_data = $email_header->getById($emailheader); //print_r($email_header_data);

		$email_header1 = new Emailheaders();
		$email_footer_data = $email_header1->getById($emailfooter);//print_r($email_footer_data);


		$header_final = $email_header_data[0]['content'];

		$footer_final = $email_footer_data[0]['content'];
		
		$email_body = $email_data[0]['body'];


		$output = $email->replaceValues($values,$email_body);

		$from = '';
		$from_name = 'Internal Software';
		$subject = $title;
		$attachment = '';
		$body = $header_final.$output.$footer_final;

		$email_Settings = new EmailSettings();

		$status = $email_Settings->sendMail($from,$from_name,$to,$cc,$bcc,$subject,$body,$attachment='');	 
		return $status;

			// $title = $title;
			// $subject = $emai_subject;	
			// $msg = $header_final .$output.$footer_final;        	
		
			// $mail  = new PHPMailer();
			// $mail->IsSMTP();
			// $mail->SMTPAuth   = true;       // enable SMTP authentication
			// $mail->SMTPSecure = "ssl";     // sets the prefix to the servier
			// $mail->Host       = 'secure227.servconfig.com';//'localhost';      // sets GMAIL as the SMTP server 
			// $mail->Port       = '465';//'465';     // set the SMTP port
			
			// $mail->Username   = 'system@akila.codeplait.net';//'system@test.universalappserver.com';  // GMAIL username 
			// $mail->Password   = '6H,%x4n2T}*J'; // GMAIL password 
			
			// $mail->From       = 'system@akila.codeplait.net';//'system@test.universalappserver.com'; // 
			// $mail->FromName   = $title;
			// $mail->Subject    = $subject;
			// $mail->WordWrap   = 50; // set word wrap
			
			// $mail->MsgHTML($msg);
			
			// $mail->AddAddress($AddAddress);

			// if (!empty($AddCC)) {
			// 	$mail->AddCC($AddCC);
			// }

			// if (!empty($AddBCC)) {

			// 	$mail->AddBCC($AddBCC);
			// }

		    		
		    
			
			// $mail->IsHTML(true); // send as HTML
			// //echo $msg;
			// if($mail->Send()){
			// //	echo "200";
				
			// }else{
			// 	//echo 'Message was not sent.';
   //             // echo 'Mailer error: ' . $mail->ErrorInfo;
			// }

     }


     // ******************added by ayona**********************

     function sendEmailToReset($data){
     	
     	// print_r($data);die();

		$email = new Emailtemplates();
		//$email_data = $email->getById($tempid);
		$email_data = $email->getByCode($data['code']); //print_r($email_data);

		//get header footer data
		$emailheader = $email_data[0]['header'];
		$emailfooter = $email_data[0]['footer'];	

		$email_header = new Emailheaders();
		$email_header_data = $email_header->getById($emailheader); //print_r($email_header_data);

		// $email_header1 = new Emailheaders();
		$email_footer_data = $email_header->getById($emailfooter);//print_r($email_footer_data);

		// print_r($email_footer_data[0]['id']);


		$header_final = $email_header_data[0]['content'];

		$footer_final = $email_footer_data[0]['content'];
		
		$email_body = $email_data[0]['body'];


		$output = $email->replaceValues($values,$email_body);
        
		$id = $data['id'];
		$type = $data['type'];
		$to = $data['to'];
		$from = '';
		$from_name = 'Job Portal';
		$subject = 'You Have reset the password';
		$attachment = '';
		$login_link = "http://ayona.codeplait.net/newjobportal/password_reset.php?id=$id&type=$type";
		$body = $header_final.$output.$data['token'].$login_link.$footer_final;

		$email_Settings = new EmailSettings();

		$status = $email_Settings->sendMailToRest($from,$from_name,$to,$subject,$body,$attachment='');	 
		return $status;

     }

     // *****************/.added by ayona*********************

}

?>