<?php 

require_once '../config.php';

$action = strip_tags($_POST['action']); 

switch ($action) {
	case 'index':
		index();
		break;

	case 'store':
		store();
		break;

	case 'edit':
		edit();
		break;

	case 'update':
		update();
		break;

	case 'destroy':
		destroy();
		break;

}


function index(){ 

	$domains = new Domains();
	$page = strip_tags($_POST['page']);
	$limit = 10000;
	$link = SITE_URL.'domains/?page=';
	$class = 'pagination';

	$Pager = new Pager();
	$query = $domains->selectAllQuery();
	$Buttons = array('&laquo;', '&raquo;');

	$all = $domains->selectAll();

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit); //print_r($data);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $link);
	}
	
	//$data = $domains->selectAll();

	$out = '';
	$modal = '';
	foreach ($data as $row) {

		if($row['status']==0){
			$class = "danger";
		}else if($row['status']==2){
			$class = "info";
		}else if($row['status']==3){
			$class = "warning";
		}else{
			$class = '';
		}

		$out .= '<tr id="row'.$row['id'].'" class="'.$class.'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['domain'].'</td>';
		$out .= '<td>'.$row['remarks'].'</td>';
		$out .=  '<td>'.$row['created_at'].'</td>';
$out .= '<td class="text-center"><a href="'.SITE_URL.'domains/edit.php?id='.$row['id'].'"> <i class="fa fa-pencil-square-o fa-lg" aria-hidden="true"></i> </a>';
		$out .= '&nbsp; &nbsp;<a href="javascript:;" class="text-danger" onclick="deleteDomain('.$row['id'].');"> <i class="fa fa-times fa-lg" aria-hidden="true"></i></a>';
		$out .= '</td>';
		$out .= '</tr>';


	}

	foreach ($data as $row) {
		$modal .= '<div id="delete_'.$row['id'].'" class="modal fade" role="dialog">
				  <div class="modal-dialog">

				    <div class="modal-content">
				      <div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				        <h4 class="modal-title">Delete Domain</h4>
				      </div>
				      <div class="modal-body">
				        <p>Are you sure you want to delete this domain.</p>
				      </div>
				      <div class="modal-footer">
				      <button type="button" class="btn btn-success" data-dismiss="modal">No</button>
				        <button type="button" class="btn btn-danger" onclick="deleteDomain('.$row['id'].')">Yes</button>
				      </div>
				    </div>

				  </div>
				</div>';
	}

	
	echo json_encode(array('table'=>$out,'modal'=>$modal,'pagination'=>$pagination));
}

function create(){
  echo 'create';
}

function store(){

	$date = date("Y-m-d H:i:s");

	$data = $_POST;
	$data['created_at'] = $date;


	$domains = new Domains();
	$insert  = $domains->store($data);

	if($insert){
		echo 200;
	}else{
		echo 400;
	}
}

function show(){
  echo 'show';
}

function edit(){
  echo 'edit';
}

function update(){

	//print_r($_POST);die();

	$date = date("Y-m-d H:i:s");

	$data = $_POST;
	$data['updated_at'] = $date;


	$domains = new Domains();
	$updates = $domains->update($data);

	

	if($updates){
		echo 200;
	}else{
		echo 400;
	}
}

function destroy(){
	
	$domains = new Domains();
	$delete = $domains->delete(strip_tags($_POST['id']));

	if($delete){
		echo 200;
	}else{
		echo 400;
	}
}

?>