<?php 

require_once '../config.php';

$action = strip_tags($_POST['action']); 

switch ($action) {
	case 'index':
		index();
		break;

	case 'applyJob':
		applyJob();
		break;

	case 'destroy':
		destroy();
		break;

	case 'getAppliedjobs':
		getAppliedjobs();
		break;

	case 'deleteAppliedJob':
		deleteAppliedJob();
		break;

}


function index(){

	$applied_jobs = new AppliedJobs();
	$all = $applied_jobs->selectAll();

	$page = strip_tags($_POST['page']);
	$limit = 10;
	$link = SITE_URL.'modules/appliedjobs/?page=';
	$class = 'pagination';

	$Pager = new Pager();
	$query = $applied_jobs->selectAllQuery();
	$Buttons = array('&laquo;', '&raquo;');

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $link);
	}

	$out = '';
	$modal = '';
	$category_data = Jobs::getJobsCategory();


	foreach ($data as $row) {

		$jobs = new Jobs();
		$job_data = $jobs->getById($row['job_id']);

		$companies = new Companies();
		$company_data = $companies->getById($job_data[0]['company_id']);

		$seekers = new Jobseekers();
		$seeker_data = $seekers->getById($row['job_seeker_id']);

		$out .= '<tr id="row'.$row['id'].'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['job_id'].'</td>';
		$out .= '<td>'.$job_data[0]['job_title'].'</td>';	
		
		$out .= '<td>'.$seeker_data[0]['first_name'].' '.$seeker_data[0]['last_name'].'</td>';

		$out .= '<td>'.$company_data[0]['name'].'</td>';

		$out .= '<td>'.$row['created_at'].'</td>';
		$out .= '<td>'.$job_data[0]['end_date'].'</td>';

		$deleteaction = '<a href="javascript:;" class="text-danger"
		  						   onclick="deleteUser('.$row['id'].');"> ';
		             
		$out .= '<td> '.$deleteaction.'<i class="metismenu-icon pe-7s-delete-user" aria-hidden="true"></i></a></td>';
		$out .= '</tr>';


	}
	echo json_encode(array('table'=>$out, 'pagination'=>$pagination));
}

function create(){
  echo 'create';
}

function applyJob(){

	// print_r($_POST);die();
	$job_seeker_id = $_SESSION['seeker_id'];

	$date = date("Y-m-d H:i:s");

	$data = $_POST;
  
	$data['created_at'] = $date;
	
	$data['job_seeker_id'] = $job_seeker_id;

	$applied_jobs = new AppliedJobs();
	$insert  = $applied_jobs->store($data);

	if($insert){
		echo 200;
	}else{
		echo 400;
	}
}

function destroy(){
	
	$applied_jobs = new AppliedJobs();
	$delete = $applied_jobs->delete(strip_tags($_POST['id']));

	if($delete){
		$activity_log = new ActivityLog();
		$activity_log->newLogRecord('appliedjobs','delete','Applied Jobs Deleted.');
		echo 200;
	}else{
		echo 400;
	}
}




function filterview(){

    $filterid = strip_tags($_POST['id']);
   

    $jobs = new Jobs();
	$all = $jobs->selectAllbyId($filterid);

  

	$page = strip_tags($_POST['page']);
	$limit = 10;
	$link = SITE_URL.'jobs/?page=';
	$class = 'pagination';

	$Pager = new Pager();
	$query = $jobs->selectAllQuerybyJobs($filterid);

  

	$Buttons = array('&laquo;', '&raquo;');

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $link);
	}

	$out = '';
	$modal = '';
	foreach ($data as $row) {

		$out .= '<tr id="row'.$row['id'].'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['name'].'</td>';
		$out .= '<td>'.$row['amount'].'</td>';
		$out .= '<td>'.$row['created_at'].'</td>';
		

		if ($row['type']=="1") {
			$out .= '<td>'."Percentage".'</td>';
		}else{
			$out .= '<td>'."Value".'</td>';
		}
		

		$val = Common::getPermissions("jobs","edit");
              if ($val== 1) {  

				$editview = '<a href="'.SITE_URL.'modules/jobs/edit.php?id='.$row['id'].'">
		   		<i class="fa fa-pencil-square-o fa-lg" aria-hidden="true"></i> </a>';
		   				    }

		   				 $val = Common::getPermissions("jobs","delete");
              if ($val== 1) { 
				$deleteaction = '<a href="javascript:;" class="text-danger"
		  						   onclick="deleteUser('.$row['id'].');"> ';
		  					}


		$out .= '<td> '.$editview.'    	

		     &nbsp; &nbsp;'.$deleteaction.'
		     <i class="fa fa-times fa-lg" aria-hidden="true"></i></a></td>';
		$out .= '</tr>';


	}

	foreach ($data as $row) {
		$modal .= '<div id="delete_'.$row['id'].'" class="modal fade" role="dialog">
				  <div class="modal-dialog">

				    <div class="modal-content">
				      <div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				        <h4 class="modal-title">Delete User</h4>
				      </div>
				      <div class="modal-body">
				        <p>Are you sure you want to delete this user.</p>
				      </div>
				      <div class="modal-footer">
				      <button type="button" class="btn btn-success" data-dismiss="modal">No</button>
				        <button type="button" class="btn btn-danger" onclick="deleteUser('.$row['id'].')">Yes</button>
				      </div>
				    </div>

				  </div>
				</div>';
	}
	echo json_encode(array('table'=>$out,'modal'=>$modal,'pagination'=>$pagination));

	
}

function getAppliedjobs(){
	$seeker_id = $_SESSION['seeker_id'];

	$applyJob = new AppliedJobs();
	$seekr_jobs = $applyJob->getAppliedjobs($seeker_id);

	$applied_jobs_div = '';

	foreach ($seekr_jobs as $seekr_job) {
		$jobs = new Jobs();
		$job_data = $jobs->getById($seekr_job['job_id']);

		$applied_jobs_div .= '<div class="job-record col-12 float-left">
                                                    
                                                   <div class="job-profile-detail-wrapper col-md-4 col-sm-12  col-12 float-left">
                                                        <h2 class="all-job-title">
                                                               '.$job_data[0]['job_title'].'
                                                        </h2>    
                                                    </div>
                                                    
                                                   
                                                    <div class=" col-md-2 col-sm-12  col-12 float-left">
                                                        <span class="start-date">
                                                           '.$seekr_job['created_at'].'
                                                        </span>
                                                   </div>
   
                                                   <div class=" col-md-2 col-sm-12  col-12 float-left">
                                                       <span class="closing-date">
                                                          '.$job_data[0]['end_date'].'
                                                       </span>
                                                  </div>
   
                                                   <div class=" col-md-2 col-sm-12  col-12 float-left">
                                                         
                                                       <span class="status yellow">
                                                           Pending
                                                       </span>  
   
                                                    </div>
   
                                                    <div class=" col-md-2 col-sm-12  col-12 float-left remove-wrapper">
                                                         
                                                       <a class="btn btn-common" onclick="deleteAppliedJob('.$seekr_job['id'].');">
                                                           Remove 
                                                       </a>  
   
                                                    </div>
                                                   
                                               </div><div id="'.$row['id'].'status_msg"><div>';
	}

	echo json_encode(array('applyJobs'=>$applied_jobs_div));
}

function deleteAppliedJob(){
	$data = $_POST;
	$id = $data['id'];
	
	// print_r($data);die();
	
	$apply_jobs_data = new AppliedJobs();

	$accedpted_status = $apply_jobs_data->getById($id);

	if ($accedpted_status[0]['accepted_status'] == 0) {
		$job = $apply_jobs_data->deletePostedJob($id);

		if($job){
			echo 200;
		}else{
			echo 400;
		}
	}else{
		echo 300;
	}

}


?>