<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Sessions
{

	static function setAdminLoginDetails($admin_id,$admin_username,$admin_full_name,$admin_type,$admin_type_deligate){

		$permi = new Userpermissions();



		$data_permi = $permi->getPermissionsById($admin_type); /////herer check

		$data_permi_deligate = $permi->getPermissionsById($admin_type_deligate);
		

		$_SESSION["admin_id"] = $admin_id;
		$_SESSION["admin_username"] = $admin_username;
		$_SESSION["admin_full_name"] = $admin_full_name;

		$_SESSION["admin_type"] = $data_permi;
		$_SESSION["admin_type_deligate"] = $data_permi_deligate;

		$_SESSION["has_deligate"] = $admin_type_deligate;
		$_SESSION["is_admin_logged"] = true;
	}	


	static function setCompanyLoginDetails($admin_id,$admin_full_name){

		$_SESSION["company_id"] = $admin_id;
		$_SESSION["company_full_name"] = $admin_full_name;
		
		$_SESSION["is_company_logged"] = true;
	}


	static function setSeekerLoginDetails($admin_id,$admin_full_name){

		$_SESSION["seeker_id"] = $admin_id;
		$_SESSION["seeker_full_name"] = $admin_full_name;
		
		$_SESSION["is_seeker_logged"] = true;
	}

	static function setUserClients($client_ids){
		$_SESSION["user_clients"] = $client_ids;
	}

	static function setUserTeamAndDesignation($team, $designation){
		$_SESSION["user_team"] = $team;
		$_SESSION["user_designation"] = $designation;
	}

	static function isAdminLogged(){
		if(isset($_SESSION['is_admin_logged']) && $_SESSION['is_admin_logged']==true){
			return true;
		}else{
			return false;
		}
	}

	static function isCompanyLogged(){
		if(isset($_SESSION['is_company_logged']) && $_SESSION['is_company_logged']==true){
			return true;
		}else{
			return false;
		}
	}

	static function getAdminId(){
		return $_SESSION["admin_id"];
	}

	static function getAdminType(){
		return $_SESSION["admin_type"];
	}

	static function getAdminTypeDeligate(){
		return $_SESSION["admin_type_deligate"];
	}

	static function getAdminHasDeligate(){
		return $_SESSION["has_deligate"];
	}

	static function getAdminFullName(){
		return $_SESSION["admin_full_name"];
	}
	
	static function adminRedirectOnNotLoggedIn(){

		if(!Sessions::isAdminLogged()){
		  header("Location: ".SITE_URL."login.php");
		  exit();
		}

	}

	static function companyRedirectOnNotLoggedIn(){

		if(!Sessions::isCompanyLogged()){
		  header("Location: index.php");
		  exit();
		}

	}

	static function getUserClients(){
		return $_SESSION["user_clients"];
	}

	static function getUserTeam(){
		return $_SESSION['user_team'];
	}

	static function getUserDesignation(){
		return $_SESSION['user_designation'];
	}

	static function logoutAdmin(){
		unset($_SESSION["admin_id"]);
		unset($_SESSION["admin_username"]);
		unset($_SESSION["is_admin_logged"]);
		unset($_SESSION["admin_full_name"]);
		unset($_SESSION["admin_type"]);
	}

	static function logoutCompany(){
		unset($_SESSION["company_id"]);
		unset($_SESSION["company_full_name"]);
		unset($_SESSION["is_company_logged"]);
	    unset($_SESSION["email"]);
		unset($_SESSION["name"]);	
	
		
	}

		static function logoutSeeker(){
		unset($_SESSION["seeker_id"]);
		unset($_SESSION["seeker_full_name"]);
		unset($_SESSION["is_seeker_logged"]);
	    unset($_SESSION["email"]);
		unset($_SESSION["first_name"]);
		unset($_SESSION["last_name"]);		
		unset($_SESSION["fbToken"]);
		unset($_SESSION["googleToken"]);
		
	}

}