<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Domains
{
	private $table_name = "domains";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [
           
            "domain" => strip_tags($data['domain']),
            "remarks" => strip_tags($data['remarks']),          
            "created_at" => strip_tags($data['created_at'])
        ]);

        return $status;
	}

	function update($data){
		$status = $this->connection->update($this->table_name, [
            
            "domain" => strip_tags($data['domain']),
            "remarks" => strip_tags($data['remarks']),            
            "updated_at" => strip_tags($data['updated_at'])
        ], ["id" => strip_tags($data['id'])]);

        return $status;
	}



	function delete($id){

		$status = $this->connection->delete($this->table_name, " WHERE id=$id ");
		return $status;
	}

	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', ' ORDER BY id DESC');
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM domains  ORDER BY created_at DESC";
	}

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id ");
		return $data;
	}

	function getAllCount(){

		$data = $this->connection->select($this->table_name, '*');
		return count($data);
	}

	function getFirstReminderSentCount(){

		$data = $this->connection->select($this->table_name, '*', " WHERE status=2 ");
		return count($data);
	}

	function getSecondReminderSentCount(){

		$data = $this->connection->select($this->table_name, '*', " WHERE status=3 ");
		return count($data);
	}

	


}

?>