<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Adverts
{
	private $table_name = "adverts";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [
            "title" => strip_tags($data['title']),
            "site_url" => strip_tags($data['site_url']),            
            "propic" => strip_tags($data['propic']),
            "accepted_status" => strip_tags($data['accepted_status']),                         
            "created_at" => strip_tags($data['created_at']),
            "created_by" => strip_tags($data['created_by'])

        ]);

        return $status;
	}

	function update($data){

		$status = $this->connection->update($this->table_name, [
            "title" => strip_tags($data['title']),
            "site_url" => strip_tags($data['site_url']),
            "propic" => strip_tags($data['propic']),
            "accepted_status" => strip_tags($data['accepted_status']),                           
    	      "updated_at" => strip_tags($data['updated_at']),
    	      "updated_by" => strip_tags($data['updated_by']),
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status            
        ], ["id" => $id]);
        return $status;
	}


      function setAsStatus($data){
            $status = $this->connection->update($this->table_name, [            
            "accepted_status" => strip_tags($data['status'])            
        ], ["id" => strip_tags($data['id'])]);
        return $status;
      }

      
      function changeRequestmailStatus($data){
            $status = $this->connection->update($this->table_name, [
            "requestmail_status" => strip_tags($data['requestmail_status'])            
        ], ["id" => strip_tags($data['id'])]);
        return $status;
      }


	function delete($id){

            date_default_timezone_set('Asia/Colombo');
            $date = date("Y-m-d H:i:s");
            
            $status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
      }

	function selectAll(array $filters = null){
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
            $data = $this->connection->select($this->table_name, '*', "WHERE deleted_at IS NULL $filter_txt ORDER BY id DESC");
            return $data;
      }

      function selectAllSearch($search_txt,array $filters = null){

            $search_txt = Common::textToSQLLikeString($search_txt);
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
           
            $data = $this->connection->query("SELECT * FROM $this->table_name WHERE (title $search_txt OR site_url $search_txt) AND deleted_at IS NULL $filter_txt ORDER BY id DESC")->fetchAll();
            return $data;
      }

	function selectAllbyId($id){

		$data = $this->connection->select($this->table_name, '*', "WHERE FIND_IN_SET($id,vendor_type)  AND deleted_at IS NULL ORDER BY id DESC");
		return $data;
	}

	function selectAllQuery(array $filters = null){
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
            return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL $filter_txt ORDER BY id DESC" ;
      }

      function selectAllQuerySearch($search_txt,array $filters = null){
            $search_txt = Common::textToSQLLikeString($search_txt);
            $filter_txt = Common::arrayToSQLWhereClause($filters,'');
            return "SELECT * FROM $this->table_name WHERE (title $search_txt OR site_url $search_txt) AND deleted_at IS NULL $filter_txt ORDER BY id DESC";
      }

	function selectAllQuerybyVendor($id){
		return "SELECT * FROM $this->table_name WHERE FIND_IN_SET($id,vendor_type) AND deleted_at IS NULL ORDER BY id DESC" ;
	}

      function selectAllQueryforApproval(){
            return "SELECT * FROM $this->table_name WHERE accepted_status=0 AND deleted_at IS NULL ORDER BY id DESC" ;
      }

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
	}
	function getusernamebyid($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
	}

      function selectAllforPublishers(){

            $data = $this->connection->select($this->table_name, '*', " WHERE FIND_IN_SET(0,vendor_type) AND accepted_status=1 AND deleted_at IS NULL");
            return $data;
      }

      function selectAllforRatecards(){

            $data = $this->connection->select($this->table_name, '*', " WHERE accepted_status=1 AND deleted_at IS NULL");
            return $data;
      }

      function selectAllforFront($id){

            $data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
            return $data;
      }

        function selectAllfordashboard(){

            $data = $this->connection->select($this->table_name, '*', "WHERE accepted_status=1  AND deleted_at IS NULL");
            return $data;
      }

      static function getAcceptedStatusType(){
            return array("Pending","Approved","Declined");
      }

      static function getEduLevel(){
            return array("O/L", "A/L","Bachelor","Masters","Doctor");
      }

      static function getGender(){
            return array("Male", "Female");
      }

      static function getServicesArray()
      {
            return array(
                  "Publisher Partner",
                  "Video Production",
                  "Digital Development",
                  "Freelancer"
            );
      }

	

}

?>