<?php 
require_once '../../system/config.php';
Sessions::adminRedirectOnNotLoggedIn();
$value = Common::getPermissions("jobseekers","add");
$jobseekers = new Jobseekers();
if ($value== 1) {
  
?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Language" content="en">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Job Portal - Dashboard </title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, shrink-to-fit=no"
    />
    <meta name="description" content="This is an example dashboard created using build-in elements and components.">

    <!-- Disable tap highlight on IE -->
    <meta name="msapplication-tap-highlight" content="no">

<link href="<?php echo SITE_URL;?>main.8d288f825d8dffbbe55e.css" rel="stylesheet"></head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-header fixed-sidebar">

 <?php include "../../includes/header.php" ?>



  <div class="app-main">


        <?php include "../../includes/slidebar.php" ?>


             <div class="app-main__outer">
                <div class="app-main__inner">
                    <div class="app-page-title">
                        <div class="page-title-wrapper">
                            <div class="page-title-heading">
                                <div class="page-title-icon">
                                    <i class="lnr-picture text-danger">
                                    </i>
                                </div>
                                <div>Add Jobseekers
                                    <div class="page-title-subheading">
                                    </div>
                                </div>
                            </div>
                            <div class="page-title-actions">
                                
                            </div> 

                         </div>
                         </div>
                           
                       <div class="main-card mb-3 card">
                            <div class="card-body">
                            <h5 class="card-title">Jobseekers add</h5>

                    <form class="col-md-10 mx-auto" action="" id="add_form" method="POST" enctype="multipart/form-data">
                               

                    <!-- Text input-->
                    <div class="form-group">
                      <label for="first_name">First Name</label>  
                     
                      <input id="first_name" name="first_name" type="text" placeholder="Enter first Name" class="form-control">
                      
                    </div> 

                     <!-- Text input-->
                    <div class="form-group">
                      <label for="last_name">Last Name</label>  
                     
                      <input id="last_name" name="last_name" type="text" placeholder="Enter last Name" class="form-control">
                      
                    </div> 
                    
                    <!-- Text input-->
                    <div class="form-group">
                      <label for="phone">Phone</label>  
                     
                      <input id="phone" name="phone" type="text" placeholder="Enter Phone number" class="form-control">
                   
                    </div>

                    

                    <!-- Text input-->
                     <div class="form-group">
                      <label for="address">Address</label>  
                     
                      <textarea id="address" name="address" type="text" placeholder="Enter address" class="form-control"> </textarea>
                   
                    </div>

                      <!-- Text input-->
                    <div class="form-group">
                      <label for="gender">Gender</label>  
                     
                      <select id="gender" name="gender" class="form-control">
                      <option selected="true" value="0" disabled="disabled">--Select Gender--</option>


                      <?php  
                          $teacher_gender = Jobseekers::getGender();
                          foreach ($teacher_gender as $key=>$val) {    ?>                  
                           

                           <option value="<?php echo $key ?>"><?php echo $val ?></option>

                           <?php  }  ?>
                     

                    </select>
                     
                    </div>


                    <!-- Text input-->
                    <div class="form-group">
                      <label for="age">DOB</label>  
                     
                      <input id="age" name="age" type="text" placeholder="Enter Date of birth" class="form-control">
                   
                    </div>


                    <!-- Text input-->
                    <div class="form-group">
                      <label for="skills">Skills</label>  
                     
                      <input id="skills" name="skills" type="text" placeholder="Enter your Skills" class="form-control">
                   
                    </div>

                     <!-- Text input-->
                    <div class="form-group">
                      <label for="edu_level">Professional Qualification</label>  
                     
                      <input id="edu_level" name="edu_level" type="text" placeholder="Enter your Professional qualifications" class="form-control">
                   
                    </div>




                    <!-- Text input-->
                     <div class="form-group">
                      <label for="description">Previous Job Experience</label>  
                     
                      <textarea id="description" name="description" type="text" placeholder="Enter Previous experience" class="form-control"> </textarea>
                   
                    </div>

                   

                     <?php 
                      $val = Common::getPermissions("jobseekers","superuser");
                      if ($val== 1) {  ?>  

                    <div class="form-group">
                      <label  for="accepted_status">Accepted Status</label>  
                     
                      <select id="accepted_status" name="accepted_status" class="form-control">
                     
                       <?php  
                          $status_types = Jobseekers::getAcceptedStatusType();
                          foreach ($status_types as $key=>$val) {    ?>                  
                           

                           <option value="<?php echo $key ?>"><?php echo $val ?></option>

                           <?php  }  ?>
                                         

                    </select>
                     
                    </div>

                   

                    <?php  }  ?>

                     <!-- Text input--> 



                    <!-- Text input-->
                    <div class="form-group">
                      <label for="email">Email</label>  
                      
                      <input id="email" name="email" type="text" placeholder="Enter Email" class="form-control">
                      
                    </div>

                       <!-- Text input-->
                      <div class="form-group">
                        <label for="password">Password</label>  
                        
                        <input id="password" name="password" type="password" placeholder="Enter Password" class="form-control">
                       
                      </div>


                        <!-- Text input-->
                       <div class="form-group">
                        <label for="propic">Profile Pic</label>  
                        <div class="col-md-6">
                         <input type="file" name="propic" accept="image/*" />
                         <small>(Image size: 400x400 px and less than 1MB)</small>
                        </div>
                       </div>

                        <!-- Text input-->
                       <div class="form-group">
                        <label for="cvdoc">CV Document</label>  
                        <div class="col-md-6">
                         <input type="file" name="cvdoc" accept="application/pdf" />
                         <small>(PDF size: less than 2MB)</small>
                        </div>
                       </div>




        
                        <input type="hidden" name="action" value="store">
                              
        
                        <div class="form-group">
                            <button  id="submitbutton" type="submit" class="btn btn-primary" name="signup" value="Sign up">Sign up</button>
                        </div>

                        </form>


                         <div id="form_submit_msg"></div>

                        </div>
                      </div>
                  </div>


                 <?php include "../../includes/footer.php" ?> 



             </div>
           </div>


    </div>
</div>
<div class="app-drawer-overlay d-none animated fadeIn"></div>
</body>
</html>

  <script type="text/javascript" src="<?php echo SITE_URL;?>assets/scripts/main.8d288f825d8dffbbe55e.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.16.0/jquery.validate.js"></script>

<script type="text/javascript">
    $(document).ready(function(){
        
        
        $("#add_form").validate({
         
            rules: {
              
                first_name: {required: true},
                last_name: {required: true},
                password: {required: true},            
                gender: {required: true},
                
                age: {required: true},
                skills: {required: true},
                edu_level: {required: true},
                email: {required: true,email: true},
                phone: {required: true,number: true,minlength: 10,maxlength: 10,startwithzero: true,
                           
                }
            },
            messages: {
               
                first_name: "<p class='text-danger'>Please enter first name</p>",
                last_name: "<p class='text-danger'>Please enter last name</p>",
                password: "<p class='text-danger'>Please enter password</p>",
                gender: "<p class='text-danger'>Please select gender</p>",
                age: "<p class='text-danger'>Please enter date of birth</p>",
                skills: "<p class='text-danger'>Please enter skills</p>",
                edu_level: "<p class='text-danger'>Please enter professional qualifications</p>",
                email: {
                  required: "<p class='text-danger'>Please enter a email address</p>",
                  email: "<p class='text-danger'>Please enter valid email address</p>"
                },
                phone: {
                            required: "<p class='text-danger'>Please enter phone number</p>",
                            number: "<p class=' text-danger'>Input only numbers</p>",
                            minlength: "<p class='text-danger'>Input only 10 numbers</p>",
                            maxlength: "<p class='text-danger'>Input only 10 numbers</p>",
                            startwithzero: "<p class='text-danger'>start number from zero</p>"
                            
                    },               
                
            },
            submitHandler: function () {

              $("#submitbutton").attr("disabled", true);
              $("#submitbutton").html('Please Wait.....');

              //  assignlocations();

                // Get form
                var form = $('#add_form')[0];

               // Create an FormData object
                var data = new FormData(form);  

              $.ajax({
                type: "POST",
                  enctype: 'multipart/form-data',
                  url: '../../system/controllers/jobseekers_controller.php',
                  data: data,
                  processData: false,
                  contentType: false,
                  cache: false,
                  timeout: 600000,

                 success: function(res) {

                console.log(res);

                  if($.trim(res)==200){
                      clearFormFieldsFront("#add_form");
                      showFrontFormMessage('#form_submit_msg','success',{message:'Successfully Added'});
                      location.reload();
                      
                    }if($.trim(res)==300){
                     
                      showFrontFormMessage('#form_submit_msg','error',{message:'Maximum File size Exceeded. Please try again'});
                      
                    }if($.trim(res)==400){
                      showFrontFormMessage('#form_submit_msg','error',{message:'Something wrong. Please try again'});
                      
                    }

                   $("#submitbutton").removeAttr("disabled");
                   $("#submitbutton").html('SAVE');
                   $('#form_submit_msg').show(); console.log(res);
                    
                    
                 },
              });
        
            }

        });    
        jQuery.validator.addMethod("startwithzero", function (value, element) {
              return this.optional(element) || /(^[0a-zA-Z].{9})$/.test(value);
        }, "start from zero.");      
    });

    
    </script>

    <?php   
  
}else{

  header("Location: ".SITE_URL."");
}

  ?>
