import { TweenMax, Elastic, Power0 } from "gsap";

const canvas = document.getElementById("hero");
const ctx = canvas.getContext("2d");

const { width, height } = canvas;

const particles = [];

const [svgWidth, svgHeight] = [439, 426.44];


const points = [
  [76.50000095367432, 203.0999994277954, 9.460000038146973],
  [61.1899995803833, 165.44999027252197, 9.460000038146973],
  [14.720000267028809, 166.63999271392822, 9.460000038146973],
  [51.66999626159668, 201.17999839782715, 12.149999618530273],
  [39.660000801086426, 171.5699920654297, 9.49000072479248],
  [80.52999877929688, 171.48001098632812, 7.620002746582031],
  [78.57001113891602, 234.760009765625, 7.870014190673828],
  [63.260019302368164, 236.27999877929688, 4.600019454956055],
  [87.51000452041626, 161.44999933242798, 2.309999942779541],
  [44.220001220703125, 185.4499969482422, 2.779998779296875],
  [25.394999504089355, 179.18500518798828, 4.285000801086426],
  [13.959999561309814, 184.1999969482422, 4.749999523162842],
  [53.72999954223633, 181.80999755859375, 4.599998474121094],
  [89.21003723144531, 154.70999145507812, 2.10003662109375],
  [29.140018463134766, 158.5399932861328, 4.460018157958984],
  [65.28999900817871, 220.76998901367188, 7.879999160766602],
  [76.93000030517578, 153.19000244140625, 7.879997253417969],
  [81.48000478744507, 219.6099944114685, 4.349999904632568],
  [67.79000186920166, 184.6700029373169, 7.119999885559082],
  [46.220001220703125, 153.1800079345703, 7.119998931884766],
  [82.52999973297119, 186.88999271392822, 4.460000038146973],
  [40.040000915527344, 271.25, 9.459999084472656],
  [59.150001525878906, 265.5799865722656, 6.790000915527344],
  [25.680001258850098, 234.1699914932251, 9.460000038146973],
  [26.639999389648438, 196.20001220703125, 10.119998931884766],
  [17.440000534057617, 268.94000244140625, 10.5],
  [7.550014019012451, 240.29000854492188, 6.0900139808654785],
  [45.029998779296875, 240.20001220703125, 7.619998931884766],
  [58.99000310897827, 248.8000044822693, 6.28000020980835],
  [14.850000619888306, 285.3299744129181, 3.200000047683716],
  [53.310001373291016, 226.77000427246094, 2.720001220703125],
  [69.65000033378601, 244.47000002861023, 2.7200000286102295],
  [54.959999084472656, 233.75999450683594, 1.9900016784667969],
  [34.93999767303467, 210, 3.34999942779541],
  [71.58999490737915, 256.5700058937073, 5.96999979019165],
  [76.46999764442444, 247.42998909950256, 2.1600000858306885],
  [55.040000915527344, 281.08001708984375, 5.590000152587891],
  [84.01000356674194, 252.4299864768982, 4.099999904632568],
  [7.429999828338623, 253.20999956130981, 4.070000171661377],
  [18.220017433166504, 250.51998901367188, 4.600018501281738],
  [7.260000228881836, 197.38999891281128, 6.610000133514404],
  [53.40999984741211, 218.63999938964844, 2.0999984741210938],
  [39.40000140666962, 190.81000125408173, 1.340000033378601],
  [27.010000228881836, 169.83999633789062, 1.3400001525878906],
  [34.13999938964844, 184.16000366210938, 1.6199989318847656],
  [3.410024404525757, 210.11499786376953, 3.410024404525757],
  [4.31000018119812, 186.0500030517578, 2.4100003242492676],
  [5.5, 178.33999276161194, 2.4100000858306885],
  [13.96999979019165, 209.05000734329224, 4.230000019073486],
  [28.26000213623047, 287.19000244140625, 7.880001068115234],
  [41.43000030517578, 221.9099884033203, 7.880001068115234],
  [43.12000036239624, 287.37999868392944, 4.349999904632568],
  [24.12999725341797, 216.80999755859375, 5.369998931884766],
  [32.279998779296875, 253.3900146484375, 7.119998931884766],
  [8.480010032653809, 223.3300018310547, 8.120010375976562],
  [47.02000045776367, 255.59999084472656, 4.459999084472656],
  [75.36000394821167, 273.64002561569214, 7.269999980926514],
  [156.7949981689453, 15.220001220703125, 6.6514739990234375],
  [137.69499969482422, 41.12999725341797, 9.467750549316406],
  [145.1399917602539, 24.65000057220459, 4.284873962402344],
  [112.68000030517578, 68.3499984741211, 12.153060913085938],
  [90.53999710083008, 50.1150016784668, 8.948192596435547],
  [115.33938598632812, 34.949997901916504, 9.48773193359375],
  [140.5099868774414, 15.624999046325684, 2.1985244750976562],
  [58.365135192871094, 118.00000381469727, 7.876564025878906],
  [103.60244369506836, 102.30000305175781, 4.604190826416016],
  [151.65282440185547, 44.50500297546387, 1.7144851684570312],
  [113.37940979003906, 50.94999885559082, 2.7768783569335938],
  [99.63675689697266, 36.64999771118164, 4.288116455078125],
  [123.12924194335938, 49.885000228881836, 4.214118957519531],
  [180.02892303466797, 26.225000381469727, 4.185951232910156],
  [185.54000854492188, 17.84500026702881, 3.088775634765625],
  [170.2816925048828, 32.624999046325684, 2.1044769287109375],
  [177.1050033569336, 17.134999752044678, 2.1013565063476562],
  [182.82176971435547, 7.74500036239624, 4.816505432128906],
  [109.16500473022461, 89.81499862670898, 5.390369415283203],
  [157.35218048095703, 33.64999771118164, 7.879234313964844],
  [83.68279647827148, 125.78499984741211, 4.354068756103516],
  [132.15409088134766, 58.334999084472656, 5.095436096191406],
  [130.43500137329102, 23.6299991607666, 6.598445892333984],
  [168.89998626708984, 22.704999923706055, 4.463584899902344],
  [170.29718017578125, 9.980000972747803, 4.7116546630859375],
  [69.82500267028809, 134.17000198364258, 9.467752456665039],
  [87.8949966430664, 139.2199935913086, 6.795265197753906],
  [74.33500289916992, 85.47999954223633, 9.467754364013672],
  [22.87220859527588, 141.81999969482422, 10.117990493774414],
  [37.251333236694336, 122.53499984741211, 10.502580642700195],
  [55.45164489746094, 82.4749984741211, 6.0914306640625],
  [88.67472457885742, 99.79999923706055, 7.626369476318359],
  [97.05572509765625, 113.91999816894531, 6.2838897705078125],
  [39.794137954711914, 141.16999053955078, 3.199014663696289],
  [94.85491943359375, 127.3799934387207, 3.5647659301757812],
  [99.99240112304688, 93.65500259399414, 1.9943923950195312],
  [52.25573539733887, 104.72999954223633, 4.12476921081543],
  [49.32499885559082, 93.86000061035156, 4.068979263305664],
  [11.470000267028809, 152.25, 2.6276369094848633],
  [20.65999984741211, 126.30999755859375, 2.627635955810547],
  [40.63999938964844, 90.56999206542969, 2.627635955810547],
  [28.18781280517578, 109.63999938964844, 1.8432731628417969],
  [22.68000030517578, 118.80999755859375, 1.3998451232910156],
  [60.135000228881836, 96.51000213623047, 4.606744766235352],
  [37.769996643066406, 102.44499588012695, 6.609363555908203],
  [73.25096893310547, 119.54999923706055, 3.202178955078125],
  [105.40499877929688, 52.22999954223633, 2.5703811645507812],
  [105.06093215942383, 45.130001068115234, 1.6141929626464844],
  [141.12277221679688, 53.88500213623047, 1.4669952392578125],
  [93.82500076293945, 66.08500099182129, 3.6421165466308594],
  [75.21589660644531, 56.814998626708984, 4.648590087890625],
  [51.41671562194824, 136.2850112915039, 6.039247512817383],
  [93.97281646728516, 81.95000076293945, 7.874244689941406],
  [60.617271423339844, 148.70499420166016, 4.354133605957031],
  [81.01781463623047, 69.4000015258789, 5.363853454589844],
  [71.25953674316406, 105.56999588012695, 7.122871398925781],
  [64.81999397277832, 68.55999755859375, 7.452093124389648],
  [83.27911758422852, 114.37999725341797, 4.464458465576172],
  [200.6050033569336, 9.625000476837158, 8.881065368652344],
  [219.18999481201172, 17.81999969482422, 6.149986267089844],
  [201.5434799194336, 23.059999465942383, 2.1887283325195312],
  [208.5931854248047, 21.8799991607666, 2.192047119140625],
  [216.8587875366211, 4.699999570846558, 4.701240539550781],
  [227.11357879638672, 8.170000076293945, 3.1872787475585938],
  [192.74999237060547, 23.290000915527344, 3.5662002563476562],
  [185.5299835205078, 409.33502197265625, 3.0860748291015625],
  [182.81000518798828, 419.4250030517578, 4.808403015136719],
  [200.60595703125, 417.5600128173828, 8.877609252929688],
  [219.20220947265625, 409.3500213623047, 6.152191162109375],
  [201.54669952392578, 404.1199951171875, 2.1921615600585938],
  [208.57830810546875, 405.2900085449219, 2.187164306640625],
  [216.73908233642578, 422.0400085449219, 4.250038146972656],
  [227.1122589111328, 419.00001525878906, 3.1859588623046875],
  [192.7589340209961, 403.8899841308594, 3.5716781616210938],
  [85.30000305175781, 263.7900085449219, 4.4984893798828125],
  [88.33000183105469, 273.75, 3.2600021362304688],
  [156.80499267578125, 411.6999969482422, 6.6487274169921875],
  [137.70500946044922, 385.7900085449219, 9.474861145019531],
  [145.14000701904297, 402.280029296875, 4.291999816894531],
  [112.68000411987305, 358.5699920654297, 12.14864730834961],
  [90.54000473022461, 376.79498291015625, 8.941852569580078],
  [115.34500122070312, 391.96002197265625, 9.489677429199219],
  [140.51915740966797, 411.2949981689453, 2.1993637084960938],
  [58.35511589050293, 308.9200134277344, 7.872171401977539],
  [103.60462951660156, 324.6300048828125, 4.6020050048828125],
  [151.6554183959961, 382.4149932861328, 1.7099838256835938],
  [113.38940811157227, 375.9599914550781, 2.776874542236328],
  [99.62531280517578, 390.25999450683594, 4.286674499511719],
  [123.13546371459961, 377.0449981689453, 4.215976715087891],
  [180.0395278930664, 400.68499755859375, 4.190986633300781],
  [170.25987243652344, 394.2949981689453, 2.1007232666015625],
  [177.09500885009766, 409.78501892089844, 2.1041030883789062],
  [109.16329193115234, 337.10499572753906, 5.3920745849609375],
  [157.33718872070312, 393.2699890136719, 7.874237060546875],
  [83.6839714050293, 301.12501525878906, 4.355381011962891],
  [132.1650047302246, 368.5950012207031, 5.100711822509766],
  [130.44796752929688, 403.2900085449219, 6.601409912109375],
  [168.9100112915039, 404.2149963378906, 4.460853576660156],
  [170.2949981689453, 416.95001220703125, 4.713836669921875],
  [69.83499526977539, 292.739990234375, 9.474864959716797],
  [87.90000915527344, 287.6999816894531, 6.7902679443359375],
  [74.34499740600586, 341.42999267578125, 9.474864959716797],
  [37.24499797821045, 305.25502014160156, 9.633713722229004],
  [55.44847869873047, 344.4349822998047, 6.094593048095703],
  [88.66999816894531, 327.1099853515625, 7.6310882568359375],
  [97.04072952270508, 313, 6.278888702392578],
  [94.86499786376953, 299.5500030517578, 3.5646820068359375],
  [99.99459457397461, 333.25498962402344, 1.9922142028808594],
  [52.26998710632324, 322.1800079345703, 4.133432388305664],
  [49.325002670288086, 333.04998779296875, 4.07335090637207],
  [20.736571311950684, 299.52000427246094, 3.6536874771118164],
  [40.63999938964844, 336.3400115966797, 2.627635955810547],
  [28.719999313354492, 317.2850036621094, 2.369424819946289],
  [23.015000343322754, 308.3699951171875, 2.114108085632324],
  [44.78499984741211, 343.11997985839844, 2.193523406982422],
  [52.04092025756836, 295.30999755859375, 4.719768524169922],
  [60.1349983215332, 330.41998291015625, 4.602375030517578],
  [37.77000045776367, 324.4649658203125, 6.613735198974609],
  [73.25455093383789, 307.3699951171875, 3.201343536376953],
  [105.39500427246094, 374.69000244140625, 2.5703811645507812],
  [105.06499862670898, 381.7799835205078, 1.6201286315917969],
  [141.12057495117188, 373.0249938964844, 1.46917724609375],
  [129.57000732421875, 359.44500732421875, 1.469757080078125],
  [52.759416580200195, 354.29498291015625, 1.4691753387451172],
  [117.41000366210938, 342.86500549316406, 1.5680389404296875],
  [93.81549453735352, 360.8450012207031, 3.641620635986328],
  [75.20185470581055, 370.1150207519531, 4.642627716064453],
  [93.9878158569336, 344.9700012207031, 7.879241943359375],
  [81.03499603271484, 357.530029296875, 5.373779296875],
  [71.24957275390625, 321.3399963378906, 7.12725830078125],
  [64.80999755859375, 358.36000061035156, 7.452095031738281],
  [83.28500366210938, 312.5299835205078, 4.4539947509765625],
  [362.50000858306885, 203.0999994277954, 9.460000038146973],
  [377.8100061416626, 165.44999027252197, 9.460000038146973],
  [424.2800073623657, 166.63999271392822, 9.460000038146973],
  [387.3299922943115, 201.17999839782715, 12.149999618530273],
  [399.3399963378906, 171.5699920654297, 9.489990234375],
  [358.4700012207031, 171.48001098632812, 7.6199951171875],
  [360.42999267578125, 234.760009765625, 7.8699951171875],
  [375.739990234375, 236.27999877929688, 4.600006103515625],
  [351.489990234375, 161.4499969482422, 2.30999755859375],
  [394.7799987792969, 185.4499969482422, 2.779998779296875],
  [413.614990234375, 179.18500518798828, 4.285003662109375],
  [425.0400085449219, 184.1999969482422, 4.75],
  [385.2699890136719, 181.80999755859375, 4.600006103515625],
  [349.7799925804138, 154.69999074935913, 2.0999999046325684],
  [409.8599853515625, 158.5399932861328, 4.459991455078125],
  [373.7099914550781, 220.76998901367188, 7.8800048828125],
  [362.07000732421875, 153.19000244140625, 7.8800048828125],
  [357.5199828147888, 219.6099944114685, 4.349999904632568],
  [371.2099914550781, 184.6800079345703, 7.1199951171875],
  [392.7799987792969, 153.1800079345703, 7.1199951171875],
  [356.4700012207031, 186.88999938964844, 4.459991455078125],
  [398.960000038147, 271.25000858306885, 9.460000038146973],
  [379.8499975204468, 265.5799779891968, 6.789999961853027],
  [413.32000732421875, 234.1699981689453, 9.459991455078125],
  [412.3599853515625, 196.20001220703125, 10.1199951171875],
  [421.55999755859375, 268.94000244140625, 10.5],
  [431.45001220703125, 240.29000854492188, 6.089996337890625],
  [393.9700164794922, 240.20001220703125, 7.6200103759765625],
  [380.0000014305115, 248.8000044822693, 6.28000020980835],
  [424.1499938964844, 285.3299865722656, 3.20001220703125],
  [385.69000124931335, 226.77999758720398, 2.7200000286102295],
  [369.3500061035156, 244.45999145507812, 2.720001220703125],
  [384.0300085544586, 233.75998902320862, 1.9900000095367432],
  [404.05999755859375, 210, 3.350006103515625],
  [367.4100036621094, 256.55999755859375, 5.970001220703125],
  [362.5299952030182, 247.42998909950256, 2.1600000858306885],
  [383.9599914550781, 281.08001708984375, 5.589996337890625],
  [354.98998403549194, 252.4299864768982, 4.099999904632568],
  [431.5700001716614, 253.20999956130981, 4.070000171661377],
  [420.7799987792969, 250.51998901367188, 4.600006103515625],
  [431.739990234375, 197.38999938964844, 6.6099853515625],
  [385.5899963378906, 218.63999938964844, 2.100006103515625],
  [399.6000061035156, 190.80999755859375, 1.339996337890625],
  [411.989990234375, 169.83999633789062, 1.339996337890625],
  [404.8599853515625, 184.16000366210938, 1.6199951171875],
  [435.5899963378906, 210.1199951171875, 3.410003662109375],
  [434.68999886512756, 186.04999947547913, 2.4100000858306885],
  [433.4999964237213, 178.33999276161194, 2.4100000858306885],
  [425.01997804641724, 209.05000734329224, 4.230000019073486],
  [410.739990234375, 287.19000244140625, 7.8800048828125],
  [397.57000732421875, 221.9099884033203, 7.8800048828125],
  [395.87999868392944, 287.37999868392944, 4.349999904632568],
  [414.8699951171875, 216.80999755859375, 5.3699951171875],
  [406.7200012207031, 253.3900146484375, 7.1199951171875],
  [430.52000427246094, 223.3300018310547, 8.120010375976562],
  [391.9800109863281, 255.59999084472656, 4.459991455078125],
  [363.6400146484375, 273.6400146484375, 7.269989013671875],
  [282.2049865722656, 15.220001220703125, 6.64874267578125],
  [301.3000030517578, 41.1299991607666, 9.465255737304688],
  [293.8599853515625, 24.650001525878906, 4.29107666015625],
  [326.30979919433594, 68.3499984741211, 12.148849487304688],
  [348.4634704589844, 50.1150016784668, 8.9453125],
  [323.6676025390625, 34.94999885559082, 9.492279052734375],
  [298.4908142089844, 15.624999523162842, 2.199371337890625],
  [380.62510681152344, 118.00000381469727, 7.8721771240234375],
  [335.38539123535156, 102.29500198364258, 4.6020050048828125],
  [287.34544372558594, 44.50500297546387, 1.7099761962890625],
  [325.62278747558594, 50.94999885559082, 2.7790679931640625],
  [339.3653106689453, 36.64999771118164, 4.2866668701171875],
  [315.8595275878906, 49.885000228881836, 4.210968017578125],
  [258.9654541015625, 26.22499942779541, 4.18597412109375],
  [253.46499633789062, 17.84500026702881, 3.0880126953125],
  [268.71913146972656, 32.624999046325684, 2.0999908447265625],
  [261.8898620605469, 17.135000228881836, 2.100738525390625],
  [256.1800003051758, 7.745000600814819, 4.808403015136719],
  [329.83404541015625, 89.81499862670898, 5.391326904296875],
  [281.6471710205078, 33.64999866485596, 7.8742523193359375],
  [355.3139953613281, 125.78499984741211, 4.355377197265625],
  [306.8450012207031, 58.334999084472656, 5.094512939453125],
  [308.5600128173828, 23.629998207092285, 6.5993804931640625],
  [270.0990905761719, 22.70500087738037, 4.459930419921875],
  [268.7049865722656, 9.980000019073486, 4.713836669921875],
  [369.1699981689453, 134.1699981689453, 9.465255737304688],
  [351.1015625, 139.2199935913086, 6.7886962890625],
  [364.66001892089844, 85.47999954223633, 9.465255737304688],
  [416.13221740722656, 141.81999969482422, 10.117996215820312],
  [401.75279235839844, 122.53499984741211, 10.504043579101562],
  [383.55149841308594, 82.47999954223633, 6.0945892333984375],
  [350.3309326171875, 99.79999923706055, 7.620697021484375],
  [341.9499969482422, 113.91999816894531, 6.2781829833984375],
  [399.2045593261719, 141.16999053955078, 3.20135498046875],
  [344.1442565917969, 127.3799934387207, 3.56390380859375],
  [339.0045928955078, 93.65500259399414, 1.9922027587890625],
  [386.7200012207031, 104.72999954223633, 4.1234130859375],
  [389.6735534667969, 93.86000061035156, 4.0718994140625],
  [427.5299987792969, 152.25, 2.62762451171875],
  [418.341064453125, 126.30999755859375, 2.628692626953125],
  [398.3599853515625, 90.56999206542969, 2.62762451171875],
  [410.80767822265625, 109.63999938964844, 1.8431396484375],
  [416.31512451171875, 118.80999755859375, 1.396636962890625],
  [378.86500549316406, 96.50500106811523, 4.6016387939453125],
  [401.2200164794922, 102.44999694824219, 6.6034393310546875],
  [365.74456787109375, 119.54999923706055, 3.20135498046875],
  [333.5950012207031, 52.229997634887695, 2.569061279296875],
  [333.944091796875, 45.130001068115234, 1.61920166015625],
  [297.8800048828125, 53.885000228881836, 1.469757080078125],
  [345.17498779296875, 66.08500480651855, 3.642120361328125],
  [363.79185485839844, 56.814998626708984, 4.6426239013671875],
  [387.57496643066406, 136.28500366210938, 6.0409393310546875],
  [345.02781677246094, 81.95000076293945, 7.8792572021484375],
  [378.3860321044922, 148.70499420166016, 4.3553619384765625],
  [357.9850158691406, 69.4000015258789, 5.373779296875],
  [367.739990234375, 105.57499694824219, 7.122406005859375],
  [374.1750183105469, 68.55999755859375, 7.455169677734375],
  [355.7290954589844, 114.38499450683594, 4.459930419921875],
  [240.64111328125, 8.429999828338623, 7.225341796875],
  [237.44830322265625, 23.059999465942383, 2.187164306640625],
  [230.68213653564453, 16.684999465942383, 2.4651107788085938],
  [230.02063751220703, 22.840001106262207, 1.3616714477539062],
  [246.24893951416016, 23.290000915527344, 3.5716781616210938],
  [253.46501922607422, 409.3350067138672, 3.0880203247070312],
  [256.19176483154297, 419.4250030517578, 4.816505432128906],
  [239.99695587158203, 415.9450225830078, 7.277275085449219],
  [237.45318603515625, 404.1199951171875, 2.192047119140625],
  [230.4149932861328, 405.2900085449219, 2.19024658203125],
  [246.23809051513672, 403.8899841308594, 3.5681076049804688],
  [353.6999969482422, 263.7900085449219, 4.4995574951171875],
  [350.6700134277344, 273.75, 3.260009765625],
  [282.19500732421875, 411.6999969482422, 6.651458740234375],
  [301.3000030517578, 385.7900085449219, 9.465255737304688],
  [293.8500061035156, 402.28001403808594, 4.29107666015625],
  [326.3219757080078, 358.5699768066406, 12.151046752929688],
  [348.46031188964844, 376.79498291015625, 8.948471069335938],
  [323.6593780517578, 391.96002197265625, 9.487747192382812],
  [298.47772216796875, 411.29498291015625, 2.19622802734375],
  [380.63734436035156, 308.9200134277344, 7.8743743896484375],
  [335.3975524902344, 324.62501525878906, 4.60418701171875],
  [287.3428192138672, 382.4149932861328, 1.7144927978515625],
  [325.6099853515625, 375.9599914550781, 2.776275634765625],
  [339.37677001953125, 390.25999450683594, 4.288116455078125],
  [315.86497497558594, 377.0449981689453, 4.2198944091796875],
  [258.9682312011719, 400.68499755859375, 4.188751220703125],
  [268.7417907714844, 394.2949981689453, 2.104583740234375],
  [232.2737579345703, 424.62498474121094, 1.52178955078125],
  [229.23340606689453, 411.80999755859375, 1.7482528686523438],
  [261.91168212890625, 409.78501892089844, 2.1044921875],
  [224.1080551147461, 425.4199981689453, 0.9483261108398438],
  [329.8346405029297, 337.10499572753906, 5.3907012939453125],
  [281.6622009277344, 393.2749938964844, 7.879241943359375],
  [355.3149871826172, 301.12501525878906, 4.3563995361328125],
  [306.8349914550781, 368.5950012207031, 5.09454345703125],
  [308.5599822998047, 403.2900085449219, 6.5993499755859375],
  [270.0858612060547, 404.2149963378906, 4.4594573974609375],
  [268.70501708984375, 416.95001220703125, 4.713836669921875],
  [369.1699981689453, 292.739990234375, 9.465255737304688],
  [351.0965576171875, 287.6999816894531, 6.793701171875],
  [364.6599884033203, 341.42999267578125, 9.465255737304688],
  [401.75120544433594, 305.25502014160156, 9.631881713867188],
  [383.5549774169922, 344.4349822998047, 6.0847930908203125],
  [350.33473205566406, 327.1099853515625, 7.6263885498046875],
  [341.9600067138672, 313, 6.2781829833984375],
  [344.135009765625, 299.5500030517578, 3.564666748046875],
  [339.0074157714844, 333.25498962402344, 1.9993896484375],
  [386.7357635498047, 322.1800079345703, 4.1247711181640625],
  [389.67523193359375, 333.0500030517578, 4.068756103515625],
  [418.2633972167969, 299.52000427246094, 3.6505126953125],
  [398.3500061035156, 336.3400115966797, 2.62762451171875],
  [410.2799987792969, 317.2850036621094, 2.36944580078125],
  [415.99497985839844, 308.3699951171875, 2.1200103759765625],
  [394.2200012207031, 343.1199951171875, 2.19049072265625],
  [386.9668731689453, 295.30999755859375, 4.7175750732421875],
  [378.85499572753906, 330.4149932861328, 4.6016387939453125],
  [401.22999572753906, 324.469970703125, 6.6097869873046875],
  [365.73097229003906, 307.3699951171875, 3.2021942138671875],
  [333.6050109863281, 374.69000244140625, 2.57098388671875],
  [333.9290313720703, 381.7799835205078, 1.6141815185546875],
  [297.8800048828125, 373.0249938964844, 1.469757080078125],
  [309.42279052734375, 359.44500732421875, 1.46697998046875],
  [386.239990234375, 354.29498291015625, 1.469757080078125],
  [321.5899963378906, 342.87001037597656, 1.56939697265625],
  [345.1844940185547, 360.8450012207031, 3.6416168212890625],
  [363.79588317871094, 370.1150207519531, 4.6485748291015625],
  [345.0128173828125, 344.9700012207031, 7.874237060546875],
  [357.9700012207031, 357.530029296875, 5.36602783203125],
  [367.75, 321.3450012207031, 7.122406005859375],
  [374.1949768066406, 358.36000061035156, 7.455169677734375],
  [355.7149963378906, 312.53497314453125, 4.4603271484375],
].map(([x, y, r]) => {
  const point = {
    x0: x + (width / 2) - (svgWidth / 2),
    y0: y + (height / 2) - (svgHeight / 2),
    x1: x < 180 ? -100 : width + 100,
    y1: x < 180 ? height + 100 : -100,
    r,
    speed: Math.random() * 0.05 * r + 2,
  };

  return point;
});

ctx.clearRect(0, 0, width, height);

ctx.fillStyle = "#EA3F43";
ctx.lineWidth = 0.4;

for (let i = 0; i < points.length; i++) {
  const { x0, y0, x1, y1, r, speed } = points[i];
  const particle = {
    x0,
    y0,
    x1,
    y1,
    r,
    speed,
  };

  TweenMax.to(particle, particle.speed, {
    x1: particle.x0, // 1 => 100
    y1: particle.y0,
    delay: particle.y0 / 300,
    ease: Power0.easeOut,
  });

  particles.push(particle);
}

const render = () => {
  requestAnimationFrame(render);
  ctx.clearRect(0, 0, width, height);

  ctx.beginPath();
  ctx.moveTo(width / 2, 0);
  ctx.lineTo(width / 2, height);
  ctx.closePath();
  ctx.stroke();

  ctx.beginPath();
  ctx.moveTo(0, height / 2);
  ctx.lineTo(width, height / 2);
  ctx.closePath();
  ctx.stroke();

  for (var i = 0, j = particles.length; i < j; i++) {
    const particle = particles[i];
    ctx.beginPath();
    ctx.arc(particle.x1, particle.y1, particle.r, 0, 2 * Math.PI);
    ctx.fill();
    ctx.closePath();
  }
};

requestAnimationFrame(render);
